/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.scoreboard;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Scoreboard;
import org.apache.commons.lang3.Validate;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftCriteria;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftObjective;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScore;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftScoreboardTranslations;
import org.bukkit.craftbukkit.v1_18_R2.scoreboard.CraftTeam;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftChatMessage;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.RenderType;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Team;

public final class CraftScoreboard
implements org.bukkit.scoreboard.Scoreboard {
    final Scoreboard board;

    CraftScoreboard(Scoreboard board) {
        this.board = board;
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, name);
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria, String displayName) throws IllegalArgumentException {
        return this.registerNewObjective(name, criteria, displayName, RenderType.INTEGER);
    }

    @Override
    public CraftObjective registerNewObjective(String name, String criteria, String displayName, RenderType renderType) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Objective name cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)displayName, (String)"Display name cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)renderType), (String)"RenderType cannot be null", (Object[])new Object[0]);
        Validate.isTrue((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("The name '" + name + "' is longer than the limit of 32767 characters"), (Object[])new Object[0]);
        Validate.isTrue((displayName.length() <= 128 ? 1 : 0) != 0, (String)("The display name '" + displayName + "' is longer than the limit of 128 characters"), (Object[])new Object[0]);
        Validate.isTrue((this.board.m_83477_(name) == null ? 1 : 0) != 0, (String)("An objective of name '" + name + "' already exists"), (Object[])new Object[0]);
        CraftCriteria craftCriteria = CraftCriteria.getFromBukkit(criteria);
        Objective objective = this.board.m_83436_(name, craftCriteria.criteria, CraftChatMessage.fromStringOrNull(displayName), CraftScoreboardTranslations.fromBukkitRender(renderType));
        return new CraftObjective(this, objective);
    }

    @Override
    public org.bukkit.scoreboard.Objective getObjective(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Name cannot be null", (Object[])new Object[0]);
        Objective nms = this.board.m_83477_(name);
        return nms == null ? null : new CraftObjective(this, nms);
    }

    public ImmutableSet<org.bukkit.scoreboard.Objective> getObjectivesByCriteria(String criteria) throws IllegalArgumentException {
        Validate.notNull((Object)criteria, (String)"Criteria cannot be null", (Object[])new Object[0]);
        ImmutableSet.Builder objectives = ImmutableSet.builder();
        for (Objective netObjective : this.board.m_83466_()) {
            CraftObjective objective = new CraftObjective(this, netObjective);
            if (!objective.getCriteria().equals(criteria)) continue;
            objectives.add((Object)objective);
        }
        return objectives.build();
    }

    public ImmutableSet<org.bukkit.scoreboard.Objective> getObjectives() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.board.m_83466_(), (Function)new Function<Objective, org.bukkit.scoreboard.Objective>(){

            public org.bukkit.scoreboard.Objective apply(Objective input) {
                return new CraftObjective(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public org.bukkit.scoreboard.Objective getObjective(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Display slot cannot be null", (Object[])new Object[0]);
        Objective objective = this.board.m_83416_(CraftScoreboardTranslations.fromBukkitSlot(slot));
        if (objective == null) {
            return null;
        }
        return new CraftObjective(this, objective);
    }

    public ImmutableSet<Score> getScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        return this.getScores(player.getName());
    }

    public ImmutableSet<Score> getScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        ImmutableSet.Builder scores = ImmutableSet.builder();
        for (Objective objective : this.board.m_83466_()) {
            scores.add((Object)new CraftScore(new CraftObjective(this, objective), entry));
        }
        return scores.build();
    }

    @Override
    public void resetScores(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        this.resetScores(player.getName());
    }

    @Override
    public void resetScores(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        for (Objective objective : this.board.m_83466_()) {
            this.board.m_83479_(entry, objective);
        }
    }

    @Override
    public Team getPlayerTeam(OfflinePlayer player) throws IllegalArgumentException {
        Validate.notNull((Object)player, (String)"OfflinePlayer cannot be null", (Object[])new Object[0]);
        PlayerTeam team = this.board.m_83500_(player.getName());
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getEntryTeam(String entry) throws IllegalArgumentException {
        Validate.notNull((Object)entry, (String)"Entry cannot be null", (Object[])new Object[0]);
        PlayerTeam team = this.board.m_83500_(entry);
        return team == null ? null : new CraftTeam(this, team);
    }

    @Override
    public Team getTeam(String teamName) throws IllegalArgumentException {
        Validate.notNull((Object)teamName, (String)"Team name cannot be null", (Object[])new Object[0]);
        PlayerTeam team = this.board.m_83489_(teamName);
        return team == null ? null : new CraftTeam(this, team);
    }

    public ImmutableSet<Team> getTeams() {
        return ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.board.m_83491_(), (Function)new Function<PlayerTeam, Team>(){

            public Team apply(PlayerTeam input) {
                return new CraftTeam(CraftScoreboard.this, input);
            }
        }));
    }

    @Override
    public Team registerNewTeam(String name) throws IllegalArgumentException {
        Validate.notNull((Object)name, (String)"Team name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((name.length() <= Short.MAX_VALUE ? 1 : 0) != 0, (String)("Team name '" + name + "' is longer than the limit of 32767 characters"), (Object[])new Object[0]);
        Validate.isTrue((this.board.m_83489_(name) == null ? 1 : 0) != 0, (String)("Team name '" + name + "' is already in use"), (Object[])new Object[0]);
        return new CraftTeam(this, this.board.m_83492_(name));
    }

    public ImmutableSet<OfflinePlayer> getPlayers() {
        ImmutableSet.Builder players = ImmutableSet.builder();
        for (Object playerName : this.board.m_83482_()) {
            players.add((Object)Bukkit.getOfflinePlayer(playerName.toString()));
        }
        return players.build();
    }

    public ImmutableSet<String> getEntries() {
        ImmutableSet.Builder entries = ImmutableSet.builder();
        for (Object entry : this.board.m_83482_()) {
            entries.add((Object)entry.toString());
        }
        return entries.build();
    }

    @Override
    public void clearSlot(DisplaySlot slot) throws IllegalArgumentException {
        Validate.notNull((Object)((Object)slot), (String)"Slot cannot be null", (Object[])new Object[0]);
        this.board.m_7136_(CraftScoreboardTranslations.fromBukkitSlot(slot), null);
    }

    public Scoreboard getHandle() {
        return this.board;
    }
}

